
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

public class GUI extends JFrame implements ActionListener{

   private Browser browser = new Browser();

   private JButton uppdatera = new JButton("Uppdatera");
   private JButton gTill = new JButton("G till");
   private JTextField adress = new JTextField(browser.getAktuellAdress(), 45);
   private JPanel knapparOchFlt = new JPanel();

   private JTextArea text = new JTextArea(browser.uppdatera(), 40, 60);
   private JScrollPane scroll = new JScrollPane(text);
   private JPanel panel = new JPanel(new BorderLayout());

   private JLabel nuvarandeAdress = new JLabel(browser.getAktuellAdress());

   public GUI(){
      super("Fredriks Browser - version 1.1");

      knapparOchFlt.add(gTill);
      knapparOchFlt.add(uppdatera);
      knapparOchFlt.add(adress);
      panel.add(knapparOchFlt, BorderLayout.NORTH);
      panel.add(scroll, BorderLayout.CENTER);
      panel.add(nuvarandeAdress, BorderLayout.SOUTH);
      add(panel);

      setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      setVisible(true);
      pack();

      gTill.addActionListener(this);
      uppdatera.addActionListener(this);

   }//GUI - konstruktor

   public void actionPerformed(ActionEvent e){
      if(e.getSource() == gTill)
         text.setText(browser.gTill(adress.getText()));

      if(e.getSource() == uppdatera){
         text.setText(browser.uppdatera());
         adress.setText(browser.getAktuellAdress());
      }//if

      if(!(text.getText().startsWith("error")))
         nuvarandeAdress.setText(browser.getAktuellAdress());
   }//actionPerformed

   public static void main(String[]a){
      new GUI();
   }//main
}//class GUI
