
import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;

/**
* den hr klassen r ett GUI fr Fredriks SuperKlient.
* menyfunktioner: 
*	-ndra adress
*	-ndra socket
*	-ndra frger
*	-ndra anvndarnamn (inte implementerat n)
*	-
*/
public class GUI extends JFrame implements Runnable, ActionListener, KeyListener{
	
	//--- den lokala trden + hjlpvariabler
	private Thread t = new Thread(this);
	private boolean alive = true;
	
	//--- ange filnamnet att hmta anvndarinfo frn samt starta filhanterare, men detta funkar inte :(
	/*private String filnamn = "user.fsk";	
	private File fil = new File(filnamn);
	private Filhanterare filhanterare = new Filhanterare(fil);*/
	
	//--- deklarera en strm fr uppfngande av System.out/err
	private PrintStream systemOutErrKanal;
	
	//--- deklarera FSK:n och dess ndvndiga variabler
	private String inetAdress;
	private int socket;
	private FSK fsk;
	
	//--- popup-menykomponenter
	private JPopupMenu popup = new JPopupMenu();
	private JMenuItem nyAdress = new JMenuItem("Ny adress och socket");
	//private JMenuItem nySocket = new JMenuItem("ndra socket fr aktuell adress");
	private JMenuItem ndraFrger = new JMenuItem("ndra frger");
	private JMenuItem visaSkapare = new JMenuItem("Skapare");
			
	//--- vriga GUI-komponenter
	private JTextArea textarea = new JTextArea("\nHgerklicka med musen i textarean fr att f upp menyn\n\n", 1,38);
	private JScrollPane textareaScrollPane = new JScrollPane(textarea);
	private JScrollBar verticalScrollBar = textareaScrollPane.getVerticalScrollBar();
	
	private JTextField textflt = new JTextField(38);
	private JButton sgknapp = new JButton("Sg");
	private JPanel panelSyd = new JPanel();
	
	private JPanel panel = new JPanel(new BorderLayout());
	
	//--- hr ska colorchooser finnas s man kan ndra frg p text och bakgrund!
	
	
	//private String separatorString = "-------- ny session --------\n"; //behvs inte tack vare hanteringen i FSK:n

	/**
	* konstruktor med adress och socket som argument
	* kallar metoden initiering med argumenten
	*/
	public GUI(String inetAdress, int socket){
		initiering(inetAdress, socket);
	}//konstruktor - Klient
	
	/**
	* metoden initierar FSK:n med argumenten adress och socketnr
	* och initierar alla GUI-komponenter samt JFramespecifika variabler
	*/
	public void initiering(String inetAdress, int socket){		
		//--- fnga upp System.out och System.err fr att f felmeddelanden i textrutan
		///*
		systemOutErrKanal = new PrintStream(new TextAreaOutputStream(textarea));
		System.setOut(systemOutErrKanal);
		System.setErr(systemOutErrKanal);
		//*/
		
		//--- initiera FSK:n
		nyFSK(inetAdress, socket);
		
		//--- hmta frger frn user.col
		/*String str = filhanterare.lsRad();
		if(str != null){
			String[]frgerna = str.split("&", 2);
			setFrger(new Color(Integer.parseInt(frgerna[0])), new Color(Integer.parseInt(frgerna[1])));
		}//if*/
		///*
		try{
			String frger;
			File fil = new File("colors.usr");
			FileReader filIn = new FileReader(fil);
			BufferedReader in = new BufferedReader(filIn);
			if(in.ready() && filIn.ready()){
				frger = in.readLine();
				in.close(); filIn.close();
				//System.out.println(frger);
				String[]frgerna = frger.split("&", 2);
				setFrger(new Color(Integer.parseInt(frgerna[0])), new Color(Integer.parseInt(frgerna[1])));
			}//if
		}//try
		catch(IOException e){
			System.out.println("IOException: File not found: user.col\nIf this is the first time you run this program, ignore this message.");
		}//catch
		//*/
		
		//--- menykomponenter
		popup.add(nyAdress);
		//popup.add(nySocket); finns i ny adress-popupen
		popup.add(ndraFrger); //ndraFrger.setEnabled(false); //fr att den inte r implementerad nnu
		popup.add(new JPopupMenu.Separator());
		popup.add(visaSkapare);
		
		nyAdress.addActionListener(this);
		ndraFrger.addActionListener(this);
		visaSkapare.addActionListener(this);
		
		//--- vriga GUI-komponenter
		textarea.setEditable(false);
		textarea.setComponentPopupMenu(popup);
		
		panelSyd.add(textflt);
		//panelSyd.add(sgknapp); //sgknappen behvs inte nr man kan trycka p enter
		
		panel.add(textareaScrollPane, BorderLayout.CENTER);
		panel.add(panelSyd, BorderLayout.SOUTH);
		
		add(panel);
		
		//sgknapp.addActionListener(this); //sgknappen behvs inte nr man kan trycka p enter
		textflt.addKeyListener(this);
		
		//--- JFramespecifikt
		//setTitle("Fredriks SuperKlient v0.5 - " + this.inetAdress); //detta grs i metoden nyFSK
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setVisible(true);
		pack();
		setSize(500,400);
			
		//--- starta trden
		t.start();
	}//initiering(String inetAdress, int socket)
	
	/**
	* implementerat frn ActionListener.
	* trycker man p nyAdress kommer en dialogruta upp med den aktuella serverinfon
	* som man kan skriva ver med ny info, dsv connecta mot en annan server.
	* Trycker man p avbryt hnder inget.
	* andra delen r dialogrutan att ndra frgerna med.
	* detta sparas till en fil p den lokala hrddisken.
	*/
	public void actionPerformed(ActionEvent e){
		/*if(e.getSource() == sgknapp){ //sgknappen behvs inte nr man kan trycka p enter
			sg();
		}//if*/
		if(e.getSource() == nyAdress){
			NyAdressPanel nyAdressPanel = new NyAdressPanel(inetAdress, socket);
			int svar = JOptionPane.showConfirmDialog(this, nyAdressPanel, "Ange ny adress och ny socket", 
				JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
			if(svar == JOptionPane.OK_OPTION)
				nyFSK(nyAdressPanel.getAdress(), nyAdressPanel.getSocket());
		}//if
		if(e.getSource() == ndraFrger){
			BytaFrgPanel bytaFrgPanel = new BytaFrgPanel(textarea.getForeground(), textarea.getBackground());
			int svar = JOptionPane.showConfirmDialog(this, bytaFrgPanel, "Vlj frg fr text och bakgrund",
				JOptionPane.OK_CANCEL_OPTION, JOptionPane.PLAIN_MESSAGE);
			if(svar == JOptionPane.OK_OPTION)
				setFrger(bytaFrgPanel.getTextfrg(), bytaFrgPanel.getBakgrundsfrg());					
		}//if
		if(e.getSource() == visaSkapare){
			JOptionPane.showMessageDialog(this, "Fredrik Vestin\nData- SystemVetenskapliga institutionen - Kista\nfred-ves@dsv.su.se", 
				"Skapare utav Fredriks SuperKlient", JOptionPane.PLAIN_MESSAGE);
		}//if
	}//actionPerformed
	
	/**
	* implementerar frn KeyListener
	*/
	public void keyPressed(KeyEvent e){
		if(e.getKeyCode() == KeyEvent.VK_ENTER){
			sg();
		}//if
	}
	public void keyReleased(KeyEvent e){}
	public void keyTyped(KeyEvent e){}
	
	/**
	* metoden startar en ny FSK och ndrar de variabler som skall ndras
	*/
	private void nyFSK(String inetAdress, int socket){
		//--- dda den FSK:n som finns
		//if(!(fsk == null)) fsk.kill(); //kanske inte behvs
	
		//--- skapa ny FSK
		fsk = new FSK(inetAdress, socket);
		
		//--- stt klassvariablerna till argumenten
		this.inetAdress = inetAdress;
		this.socket = socket;
		
		setTitle("Fredriks SuperKlient v0.5 - " + inetAdress);
	}//nyFSK
	
	/**
	* skickar till FSK:n det som str i textfltet
	*/
	private void sg(){
		fsk.skickaString(textflt.getText());//skicka det som str i textfltet
		textflt.setText("");//reseta textfltet
	}//sg()
	
	/**
	* metoden ndrar frger p det som ska ndras frger p.
	* vilka frger som ska sttas bestms via argumenten.
	*/
	private void setFrger(Color text, Color bg){
		textarea.setForeground(text);
		textarea.setBackground(bg);
		
		textflt.setForeground(text);
		textflt.setBackground(bg);
		
		/*String str = String.valueOf(text.getRGB()) + "&" + String.valueOf(bg.getRGB());
		filhanterare.skriv(str);//min filhaterare fungerar inte n... :(*/
		
		try{
			File fil = new File("colors.usr");
			FileWriter ut = new FileWriter(fil);
			if(fil.canWrite()){
				ut.write(String.valueOf(text.getRGB()) + "&" + String.valueOf(bg.getRGB()));
			}//if
			ut.flush(); ut.close();
		}//try
		catch(IOException e){
			System.out.println("IOException when trying to save colors to harddrive");
		}//catch
		//*/
	}//setFrger
	
	public void run(){
		try{
			while(alive){
				String str = fsk.taEmotString();
				if(str != null)
					textarea.append(str);
				verticalScrollBar.setValue(verticalScrollBar.getMaximum());
				t.sleep(500);
			}//while
		}//try
		catch(InterruptedException e){
			System.out.println("InterruptedException in GUI.class in method run()");
		}//catch
	}//run()
	
	public static void main(String[]a){
		int i = a.length;
		String inetAdressMain = "127.0.0.1";
		int socketMain = 2000;
		
		switch(i){
			case 0: break;
			case 1: inetAdressMain = a[0]; break;
			case 2: inetAdressMain = a[0]; socketMain = Integer.parseInt(a[1]); break;
		}//switch
		
		new GUI(inetAdressMain, socketMain);
	}//main

}//class GUI