
import javax.swing.*;
import java.awt.*;
import javax.swing.event.*;
import java.awt.event.*;

class BytaFrgPanel extends JPanel implements ChangeListener, ActionListener{
	
	private Color textfrg;
	private Color bgfrg;
	
	private JRadioButton textknapp = new JRadioButton("textfrg", true);
	private JRadioButton bgknapp = new JRadioButton("bakgrundsfrg", false);
	private ButtonGroup knappar = new ButtonGroup();//inget visuellt, bara logisk gruppering
	private JPanel sidopanel = new JPanel();
	
	private JTextArea textarea = new JTextArea("Om du gillar \ndet hr programmet\nkan du g in p \nwww.1.se fr fler  mer!", 3,3);
		
	private JColorChooser colorChooser = new JColorChooser();
	    
    protected BytaFrgPanel(Color textfrg, Color bgfrg){
	    super(new BorderLayout());
	    
	    //--lgg till i buttongroupen
	    knappar.add(textknapp);
	    knappar.add(bgknapp);
	    
	    //---lgg till i uit
	    sidopanel.add(textknapp);
	    sidopanel.add(bgknapp);
	    
	    add(sidopanel, BorderLayout.NORTH);
	    add(textarea, BorderLayout.CENTER);
	    add(colorChooser, BorderLayout.SOUTH);
	    
	    textknapp.addActionListener(this);
	    bgknapp.addActionListener(this);
	    
	    colorChooser.getSelectionModel().addChangeListener(this);
	    
	    //--- initiera med de vrden som redan r, frn argumenten till konstruktorn
	    this.textfrg = textfrg;
	    this.bgfrg = bgfrg;
	    textarea.setBackground(bgfrg);
	    colorChooser.setColor(textfrg);  
    }//konstruktor - BytaFrgPanel
	
	public void stateChanged(ChangeEvent e){
		if(textknapp.isSelected()){
			textfrg = colorChooser.getColor();
			textarea.setForeground(textfrg);
		}//if
		if(bgknapp.isSelected()){
			bgfrg = colorChooser.getColor();
			textarea.setBackground(bgfrg);
		}//if
	}//stateChanged
	
	public void actionPerformed(ActionEvent e){
		if(e.getSource() == textknapp)
			colorChooser.setColor(textfrg);
		if(e.getSource() == bgknapp)
			colorChooser.setColor(bgfrg);
	}//actionPerformed
	
	protected Color getTextfrg(){
		return textfrg;
	}//getTextfrg
	
	protected Color getBakgrundsfrg(){
		return bgfrg;
	}//getBakgrundsfrg
	
}//class BytaFrgPanel