package derpGame;
import java.awt.Color;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.*;

import DerpEngine.EventHandler;
import DerpEngine.GameAction;
import DerpEngine.GameCore;
import DerpEngine.GameState;

import java.util.*;

public class mm extends GameCore{//implements KeyListener{
	/*ImageIcon image;
	player player;
	Enemy enemy;
	ArrayList<Sprite> list = new ArrayList<Sprite>();
	
	
	//---------------------------------------------------------------- STUFF ADDED ----------------------------------------------------------------
	
	//fixa s olika display modes syns i en options meny som man ska kunna f frn ScreenManager ( screenManager skickar en arraylist p DisplayModes )
	//s detta inte behver tas med.
	private static final DisplayMode POSSIBLE_DISPLAYMODES[] = {
		new DisplayMode(800, 600, 32, 0),
		new DisplayMode(800, 600, 24, 0),
		new DisplayMode(800, 600, 16, 0)
	};
	
	private ScreenManager screen;
	private GraphicsEngine gEngine;
	private boolean ok;
	private boolean pause;
	//private long startTime;
	
	public void run()
	{
		screen = new ScreenManager();
		try{
			DisplayMode displayMode = screen.findFirstCompatibleMode(POSSIBLE_DISPLAYMODES);
			screen.setDisplayMode(displayMode, false);
			screen.getWindow().addKeyListener(this);
			screen.getWindow().setFocusTraversalKeysEnabled(false);
			
			gEngine = new GraphicsEngine(screen);
			gameLoop();
		}
		finally {
			screen.restoreScreen();
			System.out.println("DIES");
			System.exit(0);
		}
	}
	
	//--------------------------------------------------------------------------------------------------------------------------------
	
	public mm(){
		
		image = new ImageIcon("./player.png");
		
		player = new player(image, new Vector2(50,50));
		enemy = new Enemy(image, new Vector2(100,100));
		
		list.add(player);
		list.add(enemy);
		
		run();
	}
	
	
	public static void main(String[]args){
		new mm();
		
	}


	@Override
	public void keyTyped(KeyEvent e) {
		// TODO Auto-generated method stub
		
	}


	@Override
	public void keyPressed(KeyEvent e) {//TODO make objects only react on one keyPressed event 
		if(e.getKeyCode() == KeyEvent.VK_A)
		{
			player.forceChange(new Vector2(-1,0));
		}
		if(e.getKeyCode() == KeyEvent.VK_D )
		{
			player.forceChange(new Vector2(1,0));
		}
		//---------------------------------------------------------------- STUFF ADDED ----------------------------------------------------------------
		if(e.getKeyCode() == KeyEvent.VK_ESCAPE)
		{
			stop();
		}
		if(e.getKeyCode() == KeyEvent.VK_P)
		{
			pause();
		}
		if(e.getKeyCode() == KeyEvent.VK_R)
		{
			swapFullScreen();
		}
		e.consume();
		//--------------------------------------------------------------------------------------------------------------------------------
	}
	
	public void swapFullScreen()
	{
		screen.changeRes(1024,768);
	}


	@Override
	public void keyReleased(KeyEvent e) {
		// TODO Auto-generated method stub
		
	}
	
	//---------------------------------------------------------------- STUFF ADDED ----------------------------------------------------------------
	public void stop()
	{
		ok =! ok;
		System.out.println("STOP!");
	}
	public void pause()
	{
		pause =! pause;
	}
	//--------------------------------------------------------------------------------------------------------------------------------
	
	
	public void gameLoop(){

		ok = true;
		
		
		long lastFrame = System.currentTimeMillis();//-------------------------ADDED--------------------------------------------
		long currTime = lastFrame; //-------------------------ADDED--------------------------------------------
		while(ok){
			
			//---------------------------------------------------------------- STUFF ADDED ----------------------------------------------------------------
			//check if the game should pause
			
			while(pause)//must use sleep or you wont be able to change the pause value to false because it is constantly being read
			{
				
				Graphics2D g = screen.getGraphics();
				g.setColor(Color.black);
				g.fillRect(0, 0, screen.getWidth(), screen.getHeight());
				
				g.setColor(Color.white);
				//Font f = new Font("SERIF",Font.BOLD,30);
				//g.setFont(f);
				String str = Integer.toString(screen.getWidth());
				str += " : " + Integer.toString(screen.getHeight());
				g.drawString(str,100,100);
				screen.update();
				try
				{
					Thread.sleep(20);
				}
				catch(InterruptedException e){
				}
			}
			
			//long timeSinceStart = (System.currentTimeMillis() - startTime) /1000;
			
			long elapsedTime = System.currentTimeMillis() - lastFrame; //----USE ELAPSED TIME--------------------------------
			lastFrame += elapsedTime;
			//pause = true;
			
			//draw background ----------------------------------------ASK ABOUT GHOST IMAGES IF YOU DONT DRAW BACKGROUND!
			Graphics2D g = screen.getGraphics();
			g.setColor(Color.black);
			g.fillRect(0, 0, screen.getWidth(), screen.getHeight());
			g.setColor(Color.white);
			
			g.drawString("WHAT?", 100, 100);
			
			//--------------------------------------------------------------------------------------------------------------------------------
			
			for(Sprite spr : list)
			{
				spr.Update();
				//spr.paintComponent(g);
				gEngine.drawSprite(spr);
			}
			
			//screen.getGraphics().dispose(); //moved to the screen manager instead
			screen.update();//-----------------------------------------------ADDED--------------------------------------------------
			
			//player.Update();
			//System.out.println("end of loop");
			try{
				Thread.sleep(20); // sov 20 ms
			}catch(InterruptedException e){
			}
		}
		
	}*/
	
	//***********************************ADDED BY NIKLAS************************************
	private HashMap<Integer,GameAction> gameActionList = new HashMap<Integer, GameAction>();
	//**************************************************************************************
	public static void main(String[] args)
	{
		new mm().run();
		
	}
	
	private ArrayList<GameState> gameStates = new ArrayList<GameState>();
	mmEventHandler meh;
	public void init()
	{
		super.setMaxFps(60);
		System.out.println("mm INIT CALLED");
		//super.init();
		//create stuff here
		GameState menuState = new MenuState("MenuState");
		System.out.println("MenuState CREATED");
		gameStates.add(menuState);
		
//		GameState level1State = new LevelState("level1State");
//		System.out.println("level1State CREATED");
//		gameStates.add(level1State);
		meh = new mmEventHandler();
		
		System.out.println("EventHandler CREATED");
		
		//***********************************ADDED BY NIKLAS************************************
		GameAction moveLeft = new GameAction("moveLeft", GameAction.DETECT_INITIAL_PRESS_ONLY);
		//System.out.println("moveLeft CREATED");
		gameActionList.put(KeyEvent.VK_A, moveLeft);
		//System.out.println("moveLeft ADDED TO MAP");
		
		GameAction moveRight = new GameAction("moveRight", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_D,moveRight);
		
		GameAction jump = new GameAction("jump", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_SPACE, jump);
		
		GameAction swapKeyBindings = new GameAction("swapKeyBindings",GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_B, swapKeyBindings);
		
		GameAction escape = new GameAction("escape", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_ESCAPE, escape);
		
		GameAction debugPause = new GameAction("debugPause", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_R, debugPause);
		
		GameAction debugStep = new GameAction("debugStep", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_T, debugStep);
		
		GameAction stopAnim = new GameAction("stopAnim", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_J, stopAnim);
		GameAction startAnim = new GameAction("startAnim", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_K, startAnim);
		
		GameAction startSound2 = new GameAction("startSound2", GameAction.DETECT_INITIAL_PRESS_ONLY);
		gameActionList.put(KeyEvent.VK_L, startSound2);
		
		//**************************************************************************************
		System.out.println("GameActions CREATED");
	}
	
	public EventHandler getEventHandler(){
		return meh;
	}
	public ArrayList<GameState> getGameStates()
	{
		return gameStates;
	}
	
	//***********************************ADDED BY NIKLAS************************************
	public HashMap<Integer,GameAction> getGameActions()
	{
		return gameActionList;
	}
	//**************************************************************************************

	@Override
	public void setMaxFps(double targetFPS) {
		// TODO Auto-generated method stub
		
	}
}
