package derpGame;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;

import javax.swing.ImageIcon;

import DerpEngine.Animation;
import DerpEngine.GameState;
import DerpEngine.Loader;
import DerpEngine.SoundClip;
import DerpEngine.SoundManager;
import DerpEngine.Sprite;
import DerpEngine.Vector2;

class MenuState extends GameState
{
	private player player;
	
	//------------------------------------------------LJUDTEST-------------------------------------------------
	SoundManager soundManager;
	Loader loader;
	SoundClip effect,effect2, effect3;
	Animation anim;
	//World world;
	
	public void init(Loader loader)
	{
		System.out.println("MenuState INITIATING");
		this.loader = loader;
		loader.setPaths("./assets/sounds/", "./assets/images/");
		ImageIcon image = loader.loadImage("player.png");
		ImageIcon derps = loader.loadImage("floor.png");
		player = new player(image, new Vector2(50,80));
		Enemy enemy = new Enemy(image, new Vector2(450,50));
		StaticObj floor = new StaticObj(derps, new Vector2(10, 500), false);
		super.addGameObject((Sprite)floor);
		super.addGameObject((Sprite)player);
		super.addGameObject((Sprite)enemy);	
		super.setFocusObject(player, new Vector2(0,0));
		soundManager = new SoundManager();
		effect = loader.loadSound("pen.wav", soundManager);
		effect2 = loader.loadSound("zelda.wav", soundManager);
		effect3 = loader.loadSound("zelda.wav", soundManager);
		anim = new Animation(0.5);
		anim.addFrame(loader.loadImage("player.png"));
		anim.addFrame(loader.loadImage("player01.png"));
		anim.addFrame(loader.loadImage("player02.png"));
		anim.addFrame(loader.loadImage("player03.png"));
		player.addAnimation("erm", anim);
		player.setActiveAnimation("erm");
		anim.play();
		
	}
	public void runLoop(double deltaTime)
	{
		
	}
	
	public MenuState(String name)
	{
		super(name);	
	}
	
	//***********************************ADDED BY NIKLAS************************************
	public void checkGameInput()
	{
		/*if(super.gameActionIsPressed("testCrash"))
		{
			System.out.println("CRASH!!");
		}*/
		if(super.gameActionIsPressed("moveLeft"))
		{
			System.out.println("MOVE LEFT PLZ");
			player.forceChange(new Vector2(-15,0));
		}
		if(super.gameActionIsPressed("moveRight"))
		{
			System.out.println("MOVE RIGHT PLZ");
			player.forceChange(new Vector2(15,0));
		}
		if(super.gameActionIsPressed("jump"))
		{
			//JUMP PLZ
			System.out.println("JUMP PLZ");
		}
		if(super.gameActionIsPressed("debugPause"))
		{
			super.world.paused = true;
		}
		if(super.gameActionIsPressed("debugStep"))
		{
			super.world.step = true;
		}
		if(super.gameActionIsPressed("escape"))
		{
			System.out.println("SHUT DOWN PLZ!");
			super.shutDown();
		}
		if(super.gameActionIsPressed("stopAnim"))
		{
			effect2.play();
		}
		if(super.gameActionIsPressed("startAnim"))
		{
			effect3.play();
		}
		if(super.gameActionIsPressed("startSound2"))
		{
			effect3.stop();
		}
	}
	//**************************************************************************************
	
	/*public void keyPressed(KeyEvent e)
	{
		if(e.getKeyCode() == KeyEvent.VK_A)
		{
			player.forceChange(new Vector2(-1,0));
		}
		if(e.getKeyCode() == KeyEvent.VK_D )
		{
			player.forceChange(new Vector2(1,0));
		}
		//---------------------------------------------------------------- STUFF ADDED ----------------------------------------------------------------
		if(e.getKeyCode() == KeyEvent.VK_ESCAPE)
		{
			super.shutDown();
		}
		//Pausing is done by changing GameState
		if(e.getKeyCode() == KeyEvent.VK_P)
		{
			soundManager.stopAll();
			super.changeGameState("level1State", false);
		}
		//------------------------------------------------LJUDTESTS-----------------------------------------
		double tmp = 1;
		if(e.getKeyCode() == KeyEvent.VK_U)
		{
			soundManager.stopAll();
			System.out.println("load ok");
		}

		//--------------------------------------------------------------------------------------------------
		if(e.getKeyCode() == KeyEvent.VK_R)
		{
			super.world.paused = true;
		}
		if(e.getKeyCode() == KeyEvent.VK_T)
		{
			super.world.step = true;
		}
		e.consume();
	}
	public void keyReleased(KeyEvent e)
	{
		e.consume();
	}
	public void keyTyped(KeyEvent e)
	{
		e.consume();
	}*/
}