package derpGame;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

import javax.swing.ImageIcon;

import DerpEngine.Sprite;
import DerpEngine.Vector2;


public class Enemy extends Sprite{
	int hp, movement;
	private Vector2 pos, force, clamp;
	
//	public Enemy(ImageIcon image) {
//		super(image,pos);
//		hp = 1;
//		movement = 1;
//	}
	public Enemy(ImageIcon image, Vector2 pos){
		super(image,pos, true, new Vector2(0,1),true);
		this.pos = pos;
		force = new Vector2(1,0);
	}
	public double getPosX(){
		return super.getPosX();
	}
	public double getPosY(){
		return super.getPosY();
	}
	public void forceChange(Vector2 other){
		force.add(other);
		if(force.getX()< -1)
			force.setX(-1);
		if(force.getX()> 1)
			force.setX(1);
		if(force.getY() < -1)
			force.setY(-1);
		if(force.getY() > 1)
			force.setY(1);
					
	}
	public String toString(){
		return ("enemy");
	}
//	public void moveShip(){
//		this.setBounds((int)pos.getX(), (int)pos.getY(), this.getWidth(), this.getHeight());
//	}
	
//	@Override
	public void Update(){
		super.setForce(new Vector2(-1,0));
		//super.getPos().add(new Vector2(1,0));
		//moveShip();
	}
	
	public void paintComponent(Graphics2D g)
	{
		//super.paintComponent(this.getGraphics());
		AffineTransform transform = new AffineTransform();
		transform.setToTranslation(getPosX(), getPosY());
		//drawImage takes (Image, AffineTransform, ImageObserver) sista behver vi troligen inte bry oss om s anvnd null
		g.drawImage(super.getImage(),transform,null);
	}
	public void collision(Sprite spr, String str){
		
	}
}
