package DerpEngine;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.HashMap;
import javax.swing.ImageIcon;



public abstract class Sprite{
	private Vector2 pos, force;
	private ImageIcon image;
		
	HashMap<String, Animation> animations;
	String activeAnimation;
	private boolean active;
	private Body body;
	private static int staticId = 0;
	private boolean debug;
	private Vector2 gravity;
	private int id;
	

	public Sprite(ImageIcon image, Vector2 pos, boolean active, Vector2 gravity, boolean debug){
		id = staticId++;
		this.image = image;
		this.pos = pos;
		this.active = active;
		this.debug = debug;
		this.gravity = gravity;
		force = new Vector2(0,0);
		animations = new HashMap<String, Animation>();
	}
	public Graphics getGraphics(){
		return image.getImage().getGraphics();
	}
	
	public Image getImage()
	{
		if(activeAnimation != null){
			return animations.get(activeAnimation).getImage();			
		}else
			return image.getImage();
	}
	public Vector2 getPos()
	{
		return pos;
	}
	public void setPos(Vector2 newPos){
		pos = newPos;
	}
	public double getPosX()
	{
		return pos.getX();
	}
	public double getPosY()
	{
		return pos.getY();
	}
	public void setPosX(double x)
	{
		pos.setX(x);
	}
	public void setPosY(double y)
	{
		pos.setY(y);
	}
	public Vector2 getGravity()
	{
		return gravity;
	}
	public void setGravity(Vector2 grav)
	{
		gravity = grav;
	}

	public void forceChange(Vector2 other){
		force.add(other);
		if(force.getX()< -100)
			force.setX(-100);
		if(force.getX()> 100)
			force.setX(100);
		if(force.getY() < -100)
			force.setY(-100);
		if(force.getY() > 100)
			force.setY(100);				
	}
	public void setForce(Vector2 force){
		this.force = force;
	}
	public Vector2 getForce(){
		return force;
	}
	public boolean isActive(){
		return active;
	}
	public Rectangle getBounds(){
		return body.getBounds();
	}
	public Body getBody(){
		return body;
	}
	public void createBody(){
		body = new Body(this,active);
	}
	public int getId(){
		return id;
	}
	
	public void setActiveAnimation(String name){
		activeAnimation = name;
	}
	public void addAnimation(String name, Animation anim){
		animations.put(name, anim);
	}

	
	//------------------DEBUGGING---------------------
	public boolean debug(){
		return debug;
	}
	//------------------------------------------------
	
	public void Update(double deltaTime){
		if(activeAnimation != null){
			animations.get(activeAnimation).update(deltaTime);
		}
	}
	
	public abstract void collision(Sprite spr, String str);
}
