package DerpEngine;
import java.io.File;
import java.util.ArrayList;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;

//class for managing all sounds.
public class SoundManager {
	AudioFormat format;
	ArrayList<SoundClip> soundClips;
	ArrayList<SoundClip> tempClips;
	private AudioInputStream soundIn;
	private DataLine.Info info;
	private File soundFile;
	private Clip clip;
	
	public SoundManager()
	{
		format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, AudioSystem.NOT_SPECIFIED, 16, 2, 4, AudioSystem.NOT_SPECIFIED, true);
		soundClips = new ArrayList<SoundClip>();
		tempClips = new ArrayList<SoundClip>();
	}
	
	public SoundClip loadSoundClip(File file)
	{
		info = new DataLine.Info(Clip.class, format);
		soundFile = file;		
		try {
			clip = (Clip)AudioSystem.getLine(info);
			soundIn = AudioSystem.getAudioInputStream(soundFile);
			clip.open(soundIn);
		} catch (Exception e){
		}
		SoundClip temp = new SoundClip(format, clip);
		soundClips.add(temp);
		return temp;
	}
	public void stopAll()
	{
		for(SoundClip clip : soundClips){
			if(clip.isActive()){
				tempClips.add(clip);
				clip.stop();
				
			}
		}
	}
	public void resumeAll(){
		for(SoundClip clip : tempClips){
				clip.resume();
		}
		tempClips.clear();
	}
}
