package DerpEngine;
import java.io.File;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineEvent.Type;
import javax.sound.sampled.LineListener;

//class for playing sounds
//uses javax.sound.sampled to play sampled clips

public class SoundClip{
	private AudioInputStream soundIn;
	private DataLine.Info info;
	private File soundFile;
	private Clip clip;
	private int frame;
	private boolean active;
	FloatControl gainControl;
	BooleanControl muteControl;
	double vol;
	float dB;
	
	public SoundClip(AudioFormat format, Clip clip){
		info = new DataLine.Info(Clip.class, format);
		active = false;
		this.clip = clip;
		clip.start();
		clip.stop();
		gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
		muteControl = (BooleanControl)clip.getControl(BooleanControl.Type.MUTE);
		vol = 1d;
		dB = (float)(Math.log(vol)/Math.log(10.0)*20.0);;
	}
	
	public void play(){	
		if ((clip == null) || (!clip.isRunning())){
			clip.setFramePosition(0);
			try {
				clip.open(soundIn);
			} catch (Exception e){
			}
			clip.start();
		}else{
			
		}
	}
	public void pause(){
		frame = clip.getFramePosition() % clip.getFrameLength();
		clip.close();
	}
	public void resume(){
		if ((clip == null) || (!clip.isActive())){
			try {
				clip = (Clip)AudioSystem.getLine(info);
				soundIn = AudioSystem.getAudioInputStream(soundFile);
				clip.open(soundIn);
			} catch (Exception e){
			}
			clip.setFramePosition(frame);
			clip.start();
		}
	}
	public void loop(){
		clip.loop(Clip.LOOP_CONTINUOUSLY);
	}
	public void stop(){
		frame = clip.getFramePosition() % clip.getFrameLength();
		setActive();
		clip.stop();	
	}
	
	public void setVolume(double vol){
		if(vol <=0)
			muteControl.setValue(true);
		else if(vol <=1){
			muteControl.setValue(false);
			dB = (float)(Math.log(vol)/Math.log(10.0)*20.0);
			gainControl.setValue(dB);
		}
		else{
			muteControl.setValue(false);
			dB = (float)(Math.log(1)/Math.log(10.0)*20.0);
			gainControl.setValue(dB);
		}
	}
	public boolean isActive(){
		return active;//clip.isActive();
	}
	private void setActive(){
		if(clip.isActive())
			active = false;
		else
			active = true;
	}
	
}