package DerpEngine;

import java.awt.Rectangle;
import java.util.ArrayList;


public class Physics {
	ArrayList<CollisionEvent> ceList;
	Vector2 gravity;
	Rectangle bounds;
	double time, updateFreq;
	public boolean paused = false;
	public boolean step = false;
	
	public Physics(){
		updateFreq = 10;
		time = 0;
		ceList = new ArrayList<CollisionEvent>();
	}

	public void translate(Sprite sprite, Vector2 pos){
		sprite.setPosX(pos.getX());
		sprite.setPosY(pos.getY());
		sprite.getBounds().setLocation((int)pos.getX(), (int)pos.getY());
		sprite.getBody().setPos(pos);
		
	}
	
	public boolean update(double deltaTime, ArrayList<Sprite> spriteList, EventHandler eh, double maxFps)
	{
		//debugging - pause and step 1 physics step at a time.
		if(step){
			updateSprites(deltaTime, spriteList, eh, maxFps);
			resolveCollisions();			
			step = false;
		}
		if(!paused){
			updateSprites(deltaTime, spriteList, eh, maxFps);
			resolveCollisions();
			
		}	
		return true;
	}
	
	private void updateSprites(Double deltaTime, ArrayList<Sprite> spriteList, EventHandler eh, double maxFps)
	{		
		deltaTime = deltaTime/1000;
			for(Sprite spr : spriteList)
			{
				if(spr.isActive())
				{	
					if(deltaTime > 0 ){
						Vector2 tmpGrav = new Vector2(spr.getGravity().getX()*deltaTime, spr.getGravity().getY()*deltaTime);
						spr.forceChange(tmpGrav);
						Vector2 tmpForce = new Vector2(spr.getForce().getX()*deltaTime, spr.getForce().getY()*deltaTime);
						//move object
						Vector2 tmpForce2 = new Vector2(Math.round(tmpForce.getX()), Math.round(tmpForce.getY()));
						
						spr.getBody().getPos().add(tmpForce);
						spr.getBody().getBounds().setLocation((int)spr.getBody().getPosX(), (int)spr.getBody().getPosY());
						//spr.setPos(new Vector2(Math.round(spr.getBody().getPosX()), Math.round(spr.getBody().getPosY())));
						spr.setPos(new Vector2(spr.getBounds().getX(),spr.getBounds().getY()));
						//spr.getPos().add(tmpForce);
						
						//check collisions
						checkCollision(spriteList, eh, spr);
						//resolve collisions
						resolveCollisions();
					}
				}
			}
		
	}
	
	private void checkCollision(ArrayList<Sprite> spriteList, EventHandler eh, Sprite activeSprite)
	{
		for(Sprite cmpSprite : spriteList)
		{
			//ignore objects collision with itself
			if(activeSprite.getId() != cmpSprite.getId())
			{
				//check if there is a collision
				if(activeSprite.getBounds().intersects(cmpSprite.getBounds()))
				{
					//create a collision event and check if the collision is not already added
					if(ceList.isEmpty()){
						ceList.add(new CollisionEvent(activeSprite, cmpSprite));
					}
					for(CollisionEvent cev : ceList){
						if((activeSprite.getId()==cev.getActiveSprite().getId() && cmpSprite.getId()==cev.getCollisionSprite().getId()) || (cmpSprite.getId()==cev.getActiveSprite().getId() && activeSprite.getId()==cev.getCollisionSprite().getId())){
							
						}else{
							ceList.add(new CollisionEvent(activeSprite, cmpSprite));
							System.out.println("fail collision3");
						}
					}
				}
			}
		}
	}
	private void resolveCollisions()
	{
		//resolve all found collisions
		for(CollisionEvent cev : ceList)
		{
			//THE OBJECT THAT MOVED
			Sprite activeSprite = cev.getActiveSprite();
			//THE OBJECT IT CRASHED WITH
			Sprite cmpSprite = cev.getCollisionSprite();
			
			Vector2 v2S = new Vector2(activeSprite.getPosX(),activeSprite.getPosY());
			Vector2 v2B = new Vector2(activeSprite.getBody().getPosX(),activeSprite.getBody().getPosY());
			Vector2 v2Bounds = new Vector2((double)activeSprite.getBounds().getX(),(double)activeSprite.getBounds().getY());
			Vector2 v2F = new Vector2(activeSprite.getForce().getX(),activeSprite.getForce().getY());

			
			//calculate safe distance along the collision path			
			double cmpx = Math.abs((double)(activeSprite.getBounds().intersection(cmpSprite.getBounds()).getWidth()) / activeSprite.getForce().getX());
			double cmpy = Math.abs((double)(activeSprite.getBounds().intersection(cmpSprite.getBounds()).getHeight()) / activeSprite.getForce().getY());
			
			if(cmpx < cmpy)
			{
				activeSprite.getPos().add(new Vector2(-(cmpy*activeSprite.getForce().getX()), -(cmpy*activeSprite.getForce().getY())));//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
				
				if(activeSprite.getPosX() <= cmpSprite.getPosX() && activeSprite.getPosX()+activeSprite.getBounds().getWidth() > cmpSprite.getPosX()){
					
					
					//--------------------------------------CHANGE Y POS!----------------------------------------
					activeSprite.setPosX((cmpx*activeSprite.getForce().getX()));
					Vector2 tmp = new Vector2(activeSprite.getForce().getX(), 0);
					activeSprite.setForce(tmp);
					activeSprite.getBody().getPos().setY(activeSprite.getPos().getY());
					
					translate(activeSprite,new Vector2(activeSprite.getBody().getPosX(),activeSprite.getBody().getPosY()));
					
					
					//give colliding sprites info about the collision
					if(v2F.getY() < 0)
					{
						activeSprite.collision(cmpSprite,"TOP");
						cmpSprite.collision(activeSprite,"BOTTOM");

					}
					else
					{
						activeSprite.collision(cmpSprite,"BOTTOM");
						cmpSprite.collision(activeSprite,"TOP");
					}

				}else if(activeSprite.getPosX() > cmpSprite.getPosX() && activeSprite.getPosX() <= cmpSprite.getPosX()+cmpSprite.getBounds().getWidth()){
					
					//--------------------------------------CHANGE Y POS!----------------------------------------
					
					activeSprite.setPosX((cmpx*activeSprite.getForce().getX()));//_____________________________________________

					Vector2 tmp = new Vector2(activeSprite.getForce().getX(), 0);
					activeSprite.setForce(tmp);

					activeSprite.getBody().getPos().setY(activeSprite.getPos().getY());

					translate(activeSprite,new Vector2(activeSprite.getBody().getPosX(),activeSprite.getBody().getPosY()));
					
					//give colliding sprites info about the collision
					if(v2F.getY() < 0)
					{
						activeSprite.collision(cmpSprite,"TOP");
						cmpSprite.collision(activeSprite,"BOTTOM");
					}
					else
					{
						activeSprite.collision(cmpSprite,"BOTTOM");
						cmpSprite.collision(activeSprite,"TOP");
					}
					
				}else{
					
					//--------------------------------------CHANGE X POS!----------------------------------------
					activeSprite.setPosX((cmpx*activeSprite.getForce().getX()));
					
					activeSprite.getBody().getPos().setX(activeSprite.getPos().getX());
										
					translate(activeSprite,new Vector2(v2B.getX()-(cmpx*activeSprite.getForce().getX()),v2B.getY()));
					
					Vector2 tmp = new Vector2(0,activeSprite.getForce().getY());
					activeSprite.setForce(tmp);
					
					//give colliding sprites info about the collision
					if(v2F.getX() < 0)
					{
						activeSprite.collision(cmpSprite,"LEFT");
						cmpSprite.collision(activeSprite,"RIGHT");
					}
					else
					{
						activeSprite.collision(cmpSprite,"RIGHT");
						cmpSprite.collision(activeSprite,"LEFT");
					}
				}
			}
			else{
				activeSprite.getPos().add(new Vector2(-(cmpy*activeSprite.getForce().getX()), -(cmpy*activeSprite.getForce().getY())));//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
				
				if(activeSprite.getPosX() <= cmpSprite.getPosX() && activeSprite.getPosX()+activeSprite.getBounds().getWidth() > cmpSprite.getPosX()){
					
					//--------------------------------------CHANGE Y POS!----------------------------------------
					
					activeSprite.setPosX((cmpy*activeSprite.getForce().getX()));
					Vector2 tmp = new Vector2(activeSprite.getForce().getX(), 0);
					activeSprite.setForce(tmp);

					activeSprite.getBody().getPos().setY(activeSprite.getPos().getY());

					translate(activeSprite,new Vector2(activeSprite.getBody().getPosX(),activeSprite.getBody().getPosY()));
					
					//give colliding sprites info about the collision
					if(v2F.getY() < 0)
					{
						activeSprite.collision(cmpSprite,"TOP");
						cmpSprite.collision(activeSprite,"BOTTOM");
					}
					else
					{
						activeSprite.collision(cmpSprite,"BOTTOM");
						cmpSprite.collision(activeSprite,"TOP");
					}
				}else if(activeSprite.getPosX() > cmpSprite.getPosX() && activeSprite.getPosX() <= cmpSprite.getPosX()+cmpSprite.getBounds().getWidth()){
					
					
					//--------------------------------------CHANGE Y POS!----------------------------------------
					activeSprite.setPosX((cmpy*activeSprite.getForce().getX()));
					Vector2 tmp = new Vector2(activeSprite.getForce().getX(), 0);
					activeSprite.setForce(tmp);

					activeSprite.getBody().getPos().setY(activeSprite.getPos().getY());
					
					translate(activeSprite,new Vector2(activeSprite.getBody().getPosX(),activeSprite.getBody().getPosY()));

					//give colliding sprites info about the collision
					if(v2F.getY() < 0)
					{
						activeSprite.collision(cmpSprite,"TOP");
						cmpSprite.collision(activeSprite,"BOTTOM");
					}
					else
					{
						activeSprite.collision(cmpSprite,"BOTTOM");
						cmpSprite.collision(activeSprite,"TOP");
					}
					
				}else{
					
					//--------------------------------------CHANGE X POS!----------------------------------------
					activeSprite.setPosX((cmpy*activeSprite.getForce().getX()));
					activeSprite.getBody().getPos().setX(activeSprite.getPos().getX());

					translate(activeSprite,new Vector2(activeSprite.getBody().getPosX()-(cmpy*activeSprite.getForce().getX()),activeSprite.getBody().getPosY()));
					
					Vector2 tmp = new Vector2(0,activeSprite.getForce().getY());
					activeSprite.setForce(tmp);

					//give colliding sprites info about the collision
					if(v2F.getX() < 0)
					{
						activeSprite.collision(cmpSprite,"LEFT");
						cmpSprite.collision(activeSprite,"RIGHT");
					}
					else
					{
						activeSprite.collision(cmpSprite,"RIGHT");
						cmpSprite.collision(activeSprite,"LEFT");
					}
				}
			}
		}
		ceList.clear();
	}
}
