package DerpEngine;

import java.io.File;
import java.util.HashMap;

import javax.swing.ImageIcon;

//simple loader for loading images and sounds.
//keeps 1 map for already loaded images and 1 map for already loaded sounds.
public class Loader {
	private String soundPath, imagePath;
	HashMap<String, ImageIcon> imageFiles;
	HashMap<String, File> soundFiles;
	
	public Loader(){
		imageFiles = new HashMap<String, ImageIcon>();
		soundFiles = new HashMap<String, File>();
	}
	
	public void setPaths(String soundPath, String imagePath){
		this.soundPath = soundPath;
		this.imagePath = imagePath;
	}
	
	public ImageIcon loadImage(String name){
		
		if(imageFiles.get(name)!= null){
			return imageFiles.get(name);
		}else{
			ImageIcon temp = new ImageIcon(imagePath+name);
			imageFiles.put(name, temp);
			return temp;
		}
		
	}
	
	public SoundClip loadSound(String name, SoundManager sndMngr){
	    if(soundFiles.get(name)!=null){
	    	System.out.println(soundPath+name);
	    	return sndMngr.loadSoundClip(soundFiles.get(name));
	    }else{
	    	File clip = new File(soundPath+name);
	    	soundFiles.put(name, clip);
	    	System.out.println("create new sound: "+soundPath+name);
	    	return sndMngr.loadSoundClip(clip);
	    }
	}
}
