package DerpEngine;
import java.awt.*;
import java.awt.event.*;
import java.util.HashMap;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;

public class InputManager implements KeyListener
{
	private HashMap<Integer, GameAction> keyActions = new HashMap<Integer,GameAction>();
	private Component comp;
	
	public InputManager(Component comp)
	{
		this.comp = comp;
		comp.addKeyListener(this);
		comp.setFocusTraversalKeysEnabled(false);
	}
	public void mapToKey(GameAction gameAction, int keyCode)
	{
		keyActions.put(keyCode, gameAction);
	}
	public void clearAllMaps()
	{
		keyActions.clear();
	}
	public void clearMap(GameAction gameAction)
	{
		for(Map.Entry<Integer, GameAction> me : keyActions.entrySet())
		{
			if(me.getValue() == gameAction)
			{
				keyActions.remove(me.getKey());
			}
		}
		gameAction.reset();
	}
	public List getMaps(GameAction gameAction)
	{
		ArrayList list = new ArrayList();
		for(Map.Entry<Integer, GameAction> me : keyActions.entrySet())
		{
			if(me.getValue() == gameAction)
			{
				list.add(getKeyName(me.getKey()));
			}
		}
		return list;
	}
	public void resetAllGameActions()
	{
		for(Map.Entry<Integer, GameAction> me : keyActions.entrySet())
		{
			me.getValue().reset();
		}
	}
	public static String getKeyName(int keyCode)
	{
		return KeyEvent.getKeyText(keyCode);
	}
	private GameAction getKeyAction(KeyEvent e)
	{
		int keyCode = e.getKeyCode();
		if(keyActions.get(keyCode) != null)
		{
			return keyActions.get(keyCode);
		}
		else
		{
			return null;
		}
	}
	public void keyPressed(KeyEvent e)
	{
		GameAction gameAction = getKeyAction(e);
		if (gameAction != null)
		{
			gameAction.press();
		}
		e.consume();
	}
	public void keyReleased(KeyEvent e)
	{
		GameAction gameAction = getKeyAction(e);
		if (gameAction != null)
		{
			gameAction.release();
		}
		e.consume();
	}
	public void keyTyped(KeyEvent e)
	{
		e.consume();
	}
}
