package DerpEngine;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;



class GraphicsEngine
{
	public GraphicsEngine()
	{
	}
	
	public void drawSprites(ArrayList<Sprite> list, ScreenManager screen,Sprite focusObject,Vector2 offset)
	{
		int sWidth, sHeight, fObjectWidth, fObjectHeight, wantedPosX, wantedPosY, correctionX, correctionY;
		if(focusObject!=null)
		{
			sWidth = screen.getWidth();
			sHeight = screen.getHeight();
			fObjectWidth = focusObject.getImage().getWidth(null);
			fObjectHeight = focusObject.getImage().getHeight(null);
			
			wantedPosX = ((sWidth/2) - (fObjectWidth/2)+(int)offset.getX());
			wantedPosY = ((sHeight/2)-(fObjectHeight/2)+(int)offset.getY());
			correctionX = (wantedPosX - (int)focusObject.getPosX());
			correctionY = (wantedPosY - (int)focusObject.getPosY());
		}
		else
		{
			correctionX = 0;
			correctionY = 0;
		}
		
		for(Sprite spr : list)
		{
			AffineTransform transform = new AffineTransform();
			//transform.setToTranslation(Math.round(spr.getPosX())+correctionX, Math.round(spr.getPosY())+correctionY);
			transform.setToTranslation(spr.getPosX()+correctionX, spr.getPosY()+correctionY);
			
			screen.getGraphics().drawImage(spr.getImage(),transform,null);			
		}
	}
	
	public void drawSprite(Sprite spr, ScreenManager screen)
	{
		AffineTransform transform = new AffineTransform();
		transform.setToTranslation(spr.getPosX(), spr.getPosY());
		
		screen.getGraphics().drawImage(spr.getImage(),transform,null);
	}
}