package DerpEngine;

import java.awt.event.KeyEvent;
import java.util.*;



public abstract class GameState
{
	
	private boolean loaded = false;
	private String stateName;
	private ArrayList<Sprite> gameObjects = new ArrayList<Sprite>();	
	static private GameCore core;	
	private static InputManager inputManager;
	private static HashMap<String,GameAction> gameActionList;
	public static Physics world;	
	private Sprite focusObject;
	private Vector2 offset;

	public void setFocusObject(Sprite spr,Vector2 vectOffset)
	{
		focusObject = spr;
		offset = vectOffset;
	}
	public Sprite getFocusObject()
	{
		return focusObject;
	}
	public Vector2 getFocusOffset()
	{
		return offset;
	}
	
	public GameState(String name)
	{
		stateName = name;
	}
	
	public void setGameCore(GameCore core)
	{
		this.core = core;
	}
	
	public void initState(Loader loader)
	{
		if(!loaded)
		{
			init(loader);
			loaded = true;
		}
	}
	
	public void setInputManager(InputManager inputManager)
	{
		this.inputManager = inputManager;
	}
	public void setGameActions(HashMap<String,GameAction> gameActionList)
	{
		this.gameActionList = gameActionList;
	}
	public HashMap<String,GameAction> getGameActions()
	{
		return gameActionList;
	}
	public boolean gameActionIsPressed(String str)
	{
		try{
			if(gameActionList.get(str).isPressed())
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		catch(NullPointerException ex){
			return false;
		}
	}
	public void setGameAction(GameAction gAction, int key)
	{
		//
	}
	public void resetGameAction(GameAction gAction, int key)
	{

	}
	public void clearGameActions()
	{
		inputManager.clearAllMaps();
	}
	
	public abstract void checkGameInput();

	//debugging
	public void setWorld(Physics world)
	{
		this.world = world;
	}
		
	public String getName()
	{
		return stateName;
	}
	
	public void shutDown()
	{
		core.shutDown();
	}
	
	public void changeGameState(String state, boolean clearOldState)
	{
		System.out.println("changeGameState (GameState)");
		core.changeGameState(state, clearOldState);
	}
	
	public void addGameObject(Sprite spr)
	{
		gameObjects.add(spr);
		spr.createBody();	
	}
	
	public ArrayList<Sprite> getGameObjects()
	{
		return gameObjects;
	}
	
	public void removeGameObject(Sprite spr)
	{
		gameObjects.remove(spr);
	}
	
	public void clearData()
	{
		System.out.println(getName()+" CLEARING DATA");
		gameObjects.clear();
		loaded = false;
	}
	
	public void keyPressed(KeyEvent e)
	{
	}
	public void keyReleased(KeyEvent e)
	{
	}
	public void keyTyped(KeyEvent e)
	{
	}
	
	public abstract void init(Loader loader);// overwrite this and do all the loading of objects here
	
	public abstract void runLoop(double deltaTime);// overwrite this and make the stateLoop here
}