package DerpEngine;
import java.awt.Rectangle;


public class Body{
	Rectangle bounds;
	boolean active;
	Vector2 pos;
	
	public Body(Sprite sprite, boolean active){
		bounds = new Rectangle((int)sprite.getPosX(), (int)sprite.getPosY(), sprite.getImage().getWidth(null), sprite.getImage().getHeight(null));
		this.active = active;
		pos = new Vector2(sprite.getPosX(), sprite.getPosY());		
	}
	
	public Rectangle getBounds(){
		return bounds;
	}
	
	public void setActive(boolean active){
		this.active = active;
	}
	
	public boolean isActive(){
		return active;
	}
	public void setPos(Vector2 pos){
		this.pos = pos;
	}
	public Vector2 getPos(){
		return pos;
	}
	
	public double getPosX(){
		return pos.getX();
	}
	
	public double getWidth(){
		return bounds.getWidth();
	}
	
	public double getHeight(){
		return bounds.getHeight();
	}
	
	public double getPosY(){
		return pos.getY();
	}
}
