package DerpEngine;
import java.awt.Image;
import java.util.ArrayList;

import javax.swing.ImageIcon;

public class Animation {
	ArrayList<Image> frames;
	double frameTime, timeSinceLast;
	int activeFrame;
	boolean playing;
	
	public Animation(double frameTime){
		frames = new ArrayList<Image>();
		this.frameTime = frameTime*1000;
		activeFrame = 0;
		playing = false;
	}
	
	public void addFrame(ImageIcon image){
		frames.add(image.getImage());
	}
	
	public void replaceFrame(ImageIcon image, int index){
		frames.set(index, image.getImage());
	}
	
	public void play(){
		playing=true;
	}
	
	public void stop(){
		playing=false;
	}
	
	public boolean isActive(){
		return playing;
	}
	
	public Image getImage(){
		return frames.get(activeFrame);
	}
	
	public void update(double deltaTime){		
		timeSinceLast += deltaTime;
		if(playing){
			if(timeSinceLast >= frameTime){
				timeSinceLast = 0;			
				if(activeFrame == frames.size()-1){
					activeFrame = 0;
				}else{
					activeFrame++;
				}
			}
		}
	}
}
